<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T18:03:25.996656618 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Neoverse-N1" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions per Cycle (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleNeoverseN1CPU_CYCLES &gt; 0), ($InstructionsPerCycleNeoverseN1INST_RETIRED / $InstructionsPerCycleNeoverseN1CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Cycle Accounting (Neoverse-N1)">
        <series color="255,153,0" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesNeoverseN1CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesNeoverseN1STALL_FRONTEND / $FrontendStalledCyclesNeoverseN1CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesNeoverseN1CPU_CYCLES &gt; 0), min(($BackendStalledCyclesNeoverseN1STALL_BACKEND / $BackendStalledCyclesNeoverseN1CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="General (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the percentage of instructions speculatively executed that are subsequently retired" expression="if(($RetiredInstructionsPercentageNeoverseN1INST_SPEC &gt; 0), min(($RetiredInstructionsPercentageNeoverseN1INST_RETIRED / $RetiredInstructionsPercentageNeoverseN1INST_SPEC), 1), 0)" name="Retired Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch Effectiveness (Frontend Stalled Cycles) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKINeoverseN1INST_RETIRED &gt; 0), (($BranchMPKINeoverseN1BR_MIS_PRED_RETIRED / $BranchMPKINeoverseN1INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Frontend Stalled Cycles) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageNeoverseN1BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageNeoverseN1BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageNeoverseN1BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Stalled Cycles) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKINeoverseN1INST_RETIRED &gt; 0), (($ITLBMPKINeoverseN1ITLB_WALK / $ITLBMPKINeoverseN1INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKINeoverseN1INST_RETIRED &gt; 0), (($L1InstructionTLBMPKINeoverseN1L1I_TLB_REFILL / $L1InstructionTLBMPKINeoverseN1INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Instruction TLB Effectiveness (Frontend Stalled Cycles) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageNeoverseN1L1I_TLB &gt; 0), min(($ITLBWalkPercentageNeoverseN1ITLB_WALK / $ITLBWalkPercentageNeoverseN1L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageNeoverseN1L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageNeoverseN1L1I_TLB_REFILL / $L1InstructionTLBMissPercentageNeoverseN1L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction Cache Effectiveness (Frontend Stalled Cycles) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKINeoverseN1INST_RETIRED &gt; 0), (($L1ICacheMPKINeoverseN1L1I_CACHE_REFILL / $L1ICacheMPKINeoverseN1INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction Cache Effectiveness (Frontend Stalled Cycles) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageNeoverseN1L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageNeoverseN1L1I_CACHE_REFILL / $L1ICacheMissPercentageNeoverseN1L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Stalled Cycles) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKINeoverseN1INST_RETIRED &gt; 0), (($DTLBMPKINeoverseN1DTLB_WALK / $DTLBMPKINeoverseN1INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
        <series color="153,0,255" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKINeoverseN1INST_RETIRED &gt; 0), (($L1DataTLBMPKINeoverseN1L1D_TLB_REFILL / $L1DataTLBMPKINeoverseN1INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
        <series color="0,255,153" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKINeoverseN1INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKINeoverseN1L2D_TLB_REFILL / $L2UnifiedTLBMPKINeoverseN1INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Data TLB Effectiveness (Backend Stalled Cycles) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageNeoverseN1L1D_TLB &gt; 0), min(($DTLBWalkPercentageNeoverseN1DTLB_WALK / $DTLBWalkPercentageNeoverseN1L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageNeoverseN1L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageNeoverseN1L1D_TLB_REFILL / $L1DataTLBMissPercentageNeoverseN1L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageNeoverseN1L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageNeoverseN1L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageNeoverseN1L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data Cache Effectiveness (Backend Stalled Cycles) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKINeoverseN1INST_RETIRED &gt; 0), (($L1DCacheMPKINeoverseN1L1D_CACHE_REFILL / $L1DCacheMPKINeoverseN1INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheDemandMPKINeoverseN1INST_RETIRED &gt; 0), ((($L1DCacheDemandMPKINeoverseN1L1D_CACHE_REFILL_RD + $L1DCacheDemandMPKINeoverseN1L1D_CACHE_REFILL_WR) / $L1DCacheDemandMPKINeoverseN1INST_RETIRED) * 1000), 0)" name="L1D Cache Demand MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data Cache Effectiveness (Backend Stalled Cycles) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageNeoverseN1L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageNeoverseN1L1D_CACHE_REFILL / $L1DCacheMissPercentageNeoverseN1L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified Cache Effectiveness (Backend Stalled Cycles) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKINeoverseN1INST_RETIRED &gt; 0), (($L2CacheMPKINeoverseN1L2D_CACHE_REFILL / $L2CacheMPKINeoverseN1INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified Cache Effectiveness (Backend Stalled Cycles) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageNeoverseN1L2D_CACHE &gt; 0), min(($L2CacheMissPercentageNeoverseN1L2D_CACHE_REFILL / $L2CacheMissPercentageNeoverseN1L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Unified Cache Effectiveness (Backend Stalled Cycles) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKINeoverseN1INST_RETIRED &gt; 0), (($L3CacheMPKINeoverseN1L3D_CACHE_REFILL / $L3CacheMPKINeoverseN1INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Unified Cache Effectiveness (Backend Stalled Cycles) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageNeoverseN1L3D_CACHE &gt; 0), min(($L3CacheMissPercentageNeoverseN1L3D_CACHE_REFILL / $L3CacheMissPercentageNeoverseN1L3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Last Level Cache Effectiveness (Backend Stalled Cycles) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKINeoverseN1INST_RETIRED &gt; 0), (($LLCacheReadMPKINeoverseN1LL_CACHE_MISS_RD / $LLCacheReadMPKINeoverseN1INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Last Level Cache Effectiveness (Backend Stalled Cycles) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageNeoverseN1LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageNeoverseN1LL_CACHE_MISS_RD / $LLCacheReadMissPercentageNeoverseN1LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageNeoverseN1LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageNeoverseN1LL_CACHE_RD - $LLCacheReadHitPercentageNeoverseN1LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageNeoverseN1LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageNeoverseN1INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageNeoverseN1ISB_SPEC + $BarrierOperationsPercentageNeoverseN1DSB_SPEC) + $BarrierOperationsPercentageNeoverseN1DMB_SPEC) / $BarrierOperationsPercentageNeoverseN1INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
        <series color="255,0,102" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageNeoverseN1INST_SPEC &gt; 0), min((($BranchOperationsPercentageNeoverseN1BR_IMMED_SPEC + $BranchOperationsPercentageNeoverseN1BR_INDIRECT_SPEC) / $BranchOperationsPercentageNeoverseN1INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageNeoverseN1INST_SPEC &gt; 0), min(($CryptoOperationsPercentageNeoverseN1CRYPTO_SPEC / $CryptoOperationsPercentageNeoverseN1INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageNeoverseN1INST_SPEC &gt; 0), min(($IntegerOperationsPercentageNeoverseN1DP_SPEC / $IntegerOperationsPercentageNeoverseN1INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures load and store operations as a percentage of operations speculatively executed" expression="if(($LoadStoreOperationsPercentageNeoverseN1INST_SPEC &gt; 0), min(($LoadStoreOperationsPercentageNeoverseN1LDST_SPEC / $LoadStoreOperationsPercentageNeoverseN1INST_SPEC), 1), 0)" name="Load/Store Operations Percentage" units="percent"/>
        <series color="102,255,0" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageNeoverseN1INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageNeoverseN1VFP_SPEC / $FloatingPointOperationsPercentageNeoverseN1INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
        <series color="128,77,0" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageNeoverseN1INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageNeoverseN1ASE_SPEC / $AdvancedSIMDOperationsPercentageNeoverseN1INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageNeoverseN1INST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageNeoverseN1LDREX_SPEC / $LoadExclusiveInstructionsPercentageNeoverseN1INST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageNeoverseN1INST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageNeoverseN1STREX_SPEC / $StoreExclusiveInstructionsPercentageNeoverseN1INST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of load and store operations speculatively executed" expression="if(($LoadAsLoadStoreOperationsPercentageNeoverseN1LDST_SPEC &gt; 0), min(($LoadAsLoadStoreOperationsPercentageNeoverseN1LD_SPEC / $LoadAsLoadStoreOperationsPercentageNeoverseN1LDST_SPEC), 1), 0)" name="Load as Load/Store Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of load and store operations speculatively executed" expression="if(($StoreAsLoadStoreOperationsPercentageNeoverseN1LDST_SPEC &gt; 0), min(($StoreAsLoadStoreOperationsPercentageNeoverseN1ST_SPEC / $StoreAsLoadStoreOperationsPercentageNeoverseN1LDST_SPEC), 1), 0)" name="Store as Load/Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageNeoverseN1INST_SPEC &gt; 0), min(($LoadOperationsPercentageNeoverseN1LD_SPEC / $LoadOperationsPercentageNeoverseN1INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageNeoverseN1INST_SPEC &gt; 0), min(($StoreOperationsPercentageNeoverseN1ST_SPEC / $StoreOperationsPercentageNeoverseN1INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Neoverse-N1)">
        <series color="255,153,0" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageNeoverseN1INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageNeoverseN1RC_LD_SPEC / $LoadAcquireInstructionsPercentageNeoverseN1INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageNeoverseN1INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageNeoverseN1RC_ST_SPEC / $StoreReleaseInstructionsPercentageNeoverseN1INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
   </chart>
    <select-metric id="ARMv8_Neoverse_N1_metric_backend_stalled_cycles" />
    <select-metric id="ARMv8_Neoverse_N1_metric_barrier_percentage" />
    <select-metric id="ARMv8_Neoverse_N1_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv8_Neoverse_N1_metric_branch_mpki" />
    <select-metric id="ARMv8_Neoverse_N1_metric_branch_percentage" />
    <select-metric id="ARMv8_Neoverse_N1_metric_crypto_percentage" />
    <select-metric id="ARMv8_Neoverse_N1_metric_dtlb_mpki" />
    <select-metric id="ARMv8_Neoverse_N1_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv8_Neoverse_N1_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv8_Neoverse_N1_metric_integer_dp_percentage" />
    <select-metric id="ARMv8_Neoverse_N1_metric_ipc" />
    <select-metric id="ARMv8_Neoverse_N1_metric_itlb_mpki" />
    <select-metric id="ARMv8_Neoverse_N1_metric_itlb_walk_ratio" />
    <select-metric id="ARMv8_Neoverse_N1_metric_l1d_cache_demand_mpki" />
    <select-metric id="ARMv8_Neoverse_N1_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_N1_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_N1_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_N1_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Neoverse_N1_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_N1_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_N1_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_N1_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Neoverse_N1_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_N1_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_N1_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_N1_metric_l2_tlb_mpki" />
    <select-metric id="ARMv8_Neoverse_N1_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_N1_metric_l3_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_N1_metric_ldrex_percentage" />
    <select-metric id="ARMv8_Neoverse_N1_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv8_Neoverse_N1_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_N1_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv8_Neoverse_N1_metric_load_ls_percentage" />
    <select-metric id="ARMv8_Neoverse_N1_metric_load_percentage" />
    <select-metric id="ARMv8_Neoverse_N1_metric_load_store_percentage" />
    <select-metric id="ARMv8_Neoverse_N1_metric_rc_ld_percentage" />
    <select-metric id="ARMv8_Neoverse_N1_metric_rc_st_percentage" />
    <select-metric id="ARMv8_Neoverse_N1_metric_retired_insns_percent" />
    <select-metric id="ARMv8_Neoverse_N1_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Neoverse_N1_metric_simd_percentage" />
    <select-metric id="ARMv8_Neoverse_N1_metric_store_ls_percentage" />
    <select-metric id="ARMv8_Neoverse_N1_metric_store_percentage" />
    <select-metric id="ARMv8_Neoverse_N1_metric_strex_percentage" />
</template>
